﻿#include  "StdAfx.h"

#include  "ArchiveVolumeInfo.hpp"
#include  <szCodecManager.hpp>
#include  <szArchiveContent.hpp>
#include  <szArchiveDetector.hpp>
#include  <szArchiveEnumerator.hpp>
#include  <szFileArchiveVolume.hpp>
#include  <szStoredItemContainer.hpp>
#include  <szRuntimeException.hpp>
#include  <szPath.hpp>
#include  <cassert>

SZ_AN_BEG

const u64 SEARCH_LIMIT_SIZE = 256 * 1024; // 256KB

SZ_AN_END

using namespace std;
using namespace szpp;

ArchiveVolumeInfo::ArchiveVolumeInfo(const szstring &archivePath) :
  m_Opened(false), m_Path(archivePath),
  m_Handler(), m_Volume(), m_Content()
{
}

ArchiveVolumeInfo::~ArchiveVolumeInfo()
{
}

void ArchiveVolumeInfo::Open()
{
  m_Opened = false;

  // TODO: アーカイブ名が相対パスだったら入力パスに結合して絶対パスを作成

  // とりあえずは拡張子で判定して、適切なものが見つからなければ例外扱い。
  m_Handler.reset(ArchiveDetector::FindHandlerFromExtension(ExtractExtension(m_Path)));
  if (m_Handler.get() == 0)
    BOOST_THROW_EXCEPTION(RuntimeException(SZT("Cannot create handler")));

  m_Volume.reset(new FileArchiveVolume(m_Path));
  // TODO: 7z のようにファイル名が暗号化されているケースに対応するにはパスワードコールバックも必要？？？
  m_Content.reset(ArchiveEnumerator::Enumerate(m_Handler.get(), m_Volume.get(), SEARCH_LIMIT_SIZE, this, 0));
  if (m_Content.get() == 0)
    BOOST_THROW_EXCEPTION(RuntimeException(SZT("Cannot read archive detail")));

  m_Opened = true;

  // TODO: 改良。現状では、ファイル名からアーカイブタイプを判断できない場合に decoder の作成に失敗しているはず。
//  m_Decoder.reset(GetCodecManager()->CreateDecoder(m_Path));

//  auto_ptr<IFileStream> inStream(new IFileStream());

//  inStream->Open(m_Path);

  //IFileStream * ptr = inStream.get();
  // TODO: アーカイブでないファイルを読み込むと、ここで inStream.get() で auto_ptr not dereferencable とか言われるので調査。
//  m_Decoder->Open(inStream.get(), 0x100000, this, 0, 0);

//  m_Decoder->ConstructHierarchy();

//  m_Opened = true;

  //u32 count = decoder->GetNumberOfItems();

  //m_pUI->SetMaximum(count);

  //for (u32 i = 0; i < count; ++i)
  //{
  //  const StoredItem & item = decoder->GetItem(i);
  //  m_pUI->SetItem(ExtractDirectory(item.GetName(), true), ExtractFileName(item.GetName()));
  //  m_pUI->SetCurrent(i);
  //  if (m_pState->GetQuitEvent().Wait(50))
  //    break;   
  //}
}

szpp::StoredItemContainer *ArchiveVolumeInfo::GetRootContainer()
{
  assert(m_Opened);
  return m_Content->GetRoot();
}

//
// ArchiveOpenClientCallback
//

#ifndef _NO_CRYPTO

HRESULT ArchiveVolumeInfo::GetPassword(szstring *password)
{
  return S_FALSE;
}
#endif

HRESULT ArchiveVolumeInfo::SetTotal(const u64 &files, const u64 &bytes)
{
  //m_pUI->SetMaximum(100);
  return S_FALSE;
}

HRESULT ArchiveVolumeInfo::SetCompleted(const u64 &files, const u64 &bytes)
{
  return S_FALSE;
}
